<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Imagens</title>
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.17/jquery-ui.min.js"></script>
	<script type="text/javascript">

	$(function(){
		$('.available li img').draggable();
		$('#area-itens').droppable({
			hoverClass: 'x-active',
			drop: function(evt, ui){

				if(ui.draggable.parent()[0] == this){
					return;
				}
				
				var t = $(this);
				var e = ui.draggable;
				var diff = {x: evt.pageX - e.offset().left, y: evt.pageY - e.offset().top};
				
				var parent = e.parent();
				e.appendTo(t);
				parent.remove();

				// calculando novo posicionamento
				e.css({
					position: 'absolute',
					left: evt.pageX - t.offset().left - diff.x,
					top: evt.pageY - t.offset().top - diff.y
				});
			}
		});

		$('#btnSalvar').click(function(evt){
			var s = $('.status'), data={}, area = $('#area-itens'), pageSize = {width:area.width(),height:area.height()}, itens=[];
			area.find('.itens').each(function(){
				var t=$(this), item = {
					src: this.src, 
					width: t.width(), 
					height: t.height(),
					x: t.position().left,
					y: t.position().top
				};
				itens.push(item);
			});

			data.area = pageSize;
			data.itens = itens;

			s.html('Aguarde..');
			$.post('gerar.php', data, function(link){
				s.html('Imagem gerada: <a target="_blank" href="'+link+'">Clique aqui para baixar</a>');
			});
		});
	});
	
	</script>	
	
	<style type="text/css">
		#area-itens {
			position: relative;
			float: left;
			width: 300px;
			height: 450px;
			border: 1px solid black;
			overflow: hidden;
		}
		
		.available {
			float: right;
		}
		
		.buttons {
			clear: both;
		}
		
	</style>
	
</head>
<body>
	
	<div id="area-itens">
		
		
	</div>
	
	
	<ul	class="available">
		<li><img src="imagens/imagem1.jpg" class="itens" /></li>
		<li><img src="imagens/imagem2.jpg" class="itens" /></li>
		<li><img src="imagens/imagem3.jpg" class="itens" /></li>
		<li><img src="imagens/imagem4.jpg" class="itens" /></li>
	</ul>
	
	<div class="buttons">
		<input type="button" value="Salvar Imagem" id="btnSalvar" />
	</div>
	
	<div class="status"></div>
	
</body>
</html>