<?php

namespace example {
	class Base {
		
		/**
		 * Método para popular recursivamente usando um array como fonte.
		 * 
		 * @param array $source
		 * @author Hugo Ferreira da Silva
		 * @return void
		 */
		public function populate(array $source){
			if(is_array($source)){
				$reflection = new \ReflectionClass($this);
				foreach($source as $key => $value){
					$setMethod = 'set'.ucfirst($key);
					if($reflection->hasMethod($setMethod) && $reflection->getMethod($setMethod)->isPublic()){
						$reflection->getMethod($setMethod)->invokeArgs($this,array($value));
					} else {
						if(!is_array($value)){
							$this->$key = $value;
						} else {
							$field = $reflection->getProperty($key);
							$comment = $field->getDocComment();
							
							if(preg_match('#@ReferencedClass\s+(.+?)\s#', $comment, $reg)){
								$list = array();
								foreach($value as $row){
									$child = new $reg[1]();
									if($child instanceof Base){
										$child->populate($row);
									}
									$list[] = $child;
								}
								$this->$key = $list;
								
							} else {
								$this->$key = $value;
							}
						}
					}
				}
			}
		}
	}
}


/* End of file Base.php */
/* Location: Base.php */