<?php 
include("config.php");

// se esta efetuando uma ação
if(!empty($_REQUEST['acao']) && is_string($_REQUEST['acao'])){
	switch(strtolower($_REQUEST['acao'])){
		
		// se for para salvar
		case 'salvar':
			// se veio por post
			if($_SERVER['REQUEST_METHOD'] == 'POST'){
				// inicia uma entidade de persistencia
				$pessoa = new Pessoa();
				
				// se esta editando
				if(!empty($_POST['codpessoa'])){
					// pega do banco
					$pessoa->get($_POST['codpessoa']);
					
				// se é um novo cadastro
				} else {
					$pessoa->dataCadastro = time();
				}
				
				// pega os dados do formulario
				$pessoa->populateFrom($_POST);
				
				// codigos dos telefones antigos que não vamos remover
				$antigosAtualizados = array();
				
				// se tem telefones antigos
				if(!empty($_POST['telefones']['antigos'])){
					foreach($_POST['telefones']['antigos'] as $id => $numero){
						$antigosAtualizados[] = $numero;
						$telefone = new Telefone();
						$telefone->codtelefone = $id;
						$telefone->telefone = $numero;
						$pessoa->telefones[] = $telefone;
					}
				}
				
				// se tem telefones novos
				if(!empty($_POST['telefones']['novos'])){
					foreach($_POST['telefones']['novos'] as $numero){
						$antigosAtualizados[] = $numero;
						$telefone = new Telefone();
						$telefone->telefone = $numero;
						$pessoa->telefones[] = $telefone;
					}
				}
				
				// manda salvar tudo
				$pessoa->save();
				
				// removemos os telefones que
				// não foram atualizados do usuario.
				// ou seja, foram removidos
				$telefone = new Telefone();
				$telefone->where('{telefone} NOT IN (?) AND {codpessoa} = ?', $antigosAtualizados, $pessoa->codpessoa)
					->delete(true);
				
				// atualiza a pagina
				header('Location: '.$_SERVER['PHP_SELF']);
				exit;
			}
		break;
		
		// se estiver editando
		case 'editar':
			$pessoa = new Pessoa();
			if(!empty($_GET['id']) && $pessoa->get($_GET['id']) == 1){
				// colocando os dados no post
				$_POST = $pessoa->toArray();
				// pegando os telefones
				$telefones = $pessoa->fetchLink('telefones');
				// colocamos os telefones no post
				foreach($telefones as $item){
					$_POST['telefones']['antigos'][$item->codtelefone] = $item->telefone;
				}
			}
		break;
	}
}

// inicializando as variaveis
$codpessoa = empty($_POST['codpessoa']) ? '' : $_POST['codpessoa'];
$nome      = empty($_POST['nome']) ? '' : $_POST['nome'];
$cidade    = empty($_POST['cidade']) ? '' : $_POST['cidade'];
$estado    = empty($_POST['estado']) ? '' : $_POST['estado'];
$telefones = empty($_POST['telefones']) ? array() : $_POST['telefones'];

// recuperando as pessoas cadastradas
$lista = new Pessoa();
$lista->order('nome asc')
	->find();

$listaPessoas = $lista->allToArray();

?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Cadastro</title>
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.17/jquery-ui.min.js"></script>
	<script type="text/javascript">
	$(function(){
		// colocando a acao de remover nos telefones antigos
		$('.telefone a').click(btnRemover_clickHandler);

		// quando clicar no botao de adicionar telefone
		$('.add').click(function(e){
			var parent = $(this).closest('p');
			var line = $(
				'<p class="telefone">'+
				'<input type="text" name="telefones[novos][]" value="" /> - <a href="#">Remover</a>'+
				'</p>'
			);

			parent.after(line);
			line.find('a').click(btnRemover_clickHandler);
			e.preventDefault();
			return false;
		});
	});

	// remove o telefone selecionado
	function btnRemover_clickHandler(e){
		$(this).closest('p').remove();
		e.preventDefault();
		return false;
	}
	
	</script>
</head>
<body>
	<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
		<p>
			<label for="nome">Nome: </label>
			<input type="text" name="nome" id="nome" value="<?php echo $nome; ?>" />
		</p>
		<p>
			<label for="cidade">Cidade: </label>
			<input type="text" name="cidade" id="cidade" value="<?php echo $cidade; ?>" />
		</p>
		<p>
			<label for="estado">Estado: </label>
			<input type="text" name="estado" id="estado" value="<?php echo $estado; ?>" />
		</p>
		<p>
			<label for="telefones">Telefones: <a href="#" class="add">Adicionar Telefone</a></label>
		</p>
		<?php 
		if(!empty($telefones['antigos'])){
			foreach($telefones['antigos'] as $id => $telefone){
				echo '<p class="telefone">
						<input type="text" name="telefones[antigos][',$id,']" value="', $telefone,'" /> - <a href="#">Remover</a>
					</p>';
			}
		}
		?>
			<input type="hidden" name="codpessoa" value="<?php echo $codpessoa; ?>" />
			<input type="submit" name="acao" id="acao" value="Salvar" />
		<p>
		</p>
	</form>
	
	<h1>Pessoas cadastradas</h1>
	
	<?php 
	
	foreach($listaPessoas as $item){
		echo '<p>', $item['nome'], ' - <a href="?acao=editar&id=', $item['codpessoa'], '"> editar </a></p>';
	}
	
	?>
	
</body>
</html>