<?php 

if(!empty($_POST)){
	// including files
	include 'bean/User.php';
	include 'validation/Executor.php';
	include 'validation/rules/RequiredEmail.php';
	include 'validation/rules/RequiredString.php';
	
	// 1 - creating a new User instance and filling it with proper values
	$bean = new bean\User();
	$bean->setName($_POST['name']);
	$bean->setEmail($_POST['email']);
	$bean->setPassword($_POST['password']);
	
	// 2 - creating an executor and adding some rules 
	$ruleExec = new validation\Executor();
	$ruleExec->addRule(new validation\rules\RequiredString('name','Supply your name'));
	$ruleExec->addRule(new validation\rules\RequiredString('password','Supply your password'));
	$ruleExec->addRule(new validation\rules\RequiredString('password','Your password must have between 4 and 8 chars', 4, 8));
	$ruleExec->addRule(new validation\rules\RequiredEmail('email','Supply a valid e-mail address'));
	
	// 3 - execute the validation
	$errors = $ruleExec->validate($bean);

	if(empty($errors)){
		// no errors, yeah!
		// do whatever you want, like save in a database :D
	}
}

?>
<!DOCTYPE html>
<html>
	<head>
		<title>Validation Test</title>
	    <link href="http://twitter.github.com/bootstrap/assets/css/bootstrap.css" rel="stylesheet">
	</head>

	<body>
		
		<div class="container">
			<form class="form form-horizontal" action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
				
				<fieldset>
					<legend>New User</legend>
				</fieldset>
				
				<?php 
				if(!empty($errors)){
					
					echo '<div class="alert alert-danger">', implode('<br>', $errors), '</div>';
				}
				
				?>
				
				<div class="control-group">
					<label class="control-label">Name</label>
					<div class="controls">
						<input type="text" name="name" id="name" value="<?php echo empty($_POST['name']) ? '' : $_POST['name']; ?>">
					</div>
				</div>
				
				<div class="control-group">
					<label class="control-label">E-mail</label>
					<div class="controls">
						<input type="text" name="email" id="email" value="<?php echo empty($_POST['email']) ? '' : $_POST['email']; ?>">
					</div>
				</div>
				
				<div class="control-group">
					<label class="control-label">Password</label>
					<div class="controls">
						<input type="password" name="password" id="password">
					</div>
				</div>
				
				<div class="form-actions">
				  <button type="submit" class="btn btn-primary">Save </button>
				  <button type="button" class="btn">Cancel</button>
				</div>
				
			</form>
		</div>
	</body>

</html>