<?php

namespace validation {
	
	use validation\rules\AbstractRule;

	/**
	 * Class that executes a group of validation rules into an object 
	 *
	 * @author Hugo Ferreira da Silva
	 */
	class Executor {
		
		/**
		 * Rules registered to this object
		 * @var SplObjectStorage
		 */
		private $rules;
		
		/**
		 * Constructor
		 *
		 * Initializes the validation list
		 * 
		 * @author Hugo Ferreira da Silva
		 */
		public function __construct(){
			$this->rules = new \SplObjectStorage();
		}
		
		/**
		 * Executes all rules registered to this object
		 * 
		 * @author Hugo Ferreira da Silva
		 * @return array List containing the results of validation. Filled only when some error occur.
		 */
		public function validate($subject){
			$this->rules->rewind();
			$errors = array();
			while($this->rules->valid()){
				/* @var $rule AbstractRule */
				$rule = $this->rules->current();
				$field = $rule->getField();
				
				if(!array_key_exists($field, $errors) && $rule->execute($subject) !== true){
					$errors[$field] = $rule->getErrorMessage();
				}
				
				$this->rules->next();
			}
			return $errors;
		}
		
		/**
		 * Add a rule to object's validation list 
		 * 
		 * @param AbstractRule $rule
		 * @author Hugo Ferreira da Silva
		 * @return void
		 */
		public function addRule(AbstractRule $rule){
			if(!$this->rules->contains($rule)){
				$this->rules->attach($rule);
			}
		}
		
		/**
		 * Remove a rule from object's validation list
		 * 
		 * @param AbstractRule $rule
		 * @author Hugo Ferreira da Silva
		 * @return void
		 */
		public function removeRule(AbstractRule $rule){
			if(!$this->rules->contains($rule)){
				$this->rules->detach($rule);
			}
		}
	}
}


/* End of file Subject.php */
/* Location: Subject.php */