<?php

namespace validation\rules {
	
	include_once __DIR__ . DIRECTORY_SEPARATOR . 'AbstractRule.php';
	
	use validation\Subject;

	/**
	 * Validates if the supplied string is in a valid email format
	 *
	 * @author Hugo Ferreira da Silva
	 *
	 */
	class RequiredEmail extends AbstractRule {
		
		/**
		 * (non-PHPdoc)
		 * @see validation\rules.AbstractRule::execute()
		 */
		public function execute($obj){
			return \filter_var((string) $this->getFieldValue($obj), \FILTER_VALIDATE_EMAIL) !== false;
		}
		
	}
	
}


/* End of file RequiredString.php */
/* Location: RequiredString.php */

