<?php

namespace validation\rules {
	
	include_once __DIR__ . DIRECTORY_SEPARATOR . 'AbstractRule.php';
	
	use validation\Subject;

	/**
	 * Validates if the supplied value is really a valid number
	 *
	 * @author Hugo Ferreira da Silva
	 *
	 */
	class RequiredNumber extends AbstractRule {
		
		/**
		 * minimum value
		 * @var number
		 */
		private $minvalue;
		/**
		 * maximum value
		 * @var number
		 */
		private $maxvalue;
		
		/**
		 * Constructor
		 * 
		 * @param string $field
		 * @param string $errorMessage
		 * @param number $minvalue
		 * @param number $maxvalue
		 * @author Hugo Ferreira da Silva
		 */
		public function __construct($field, $errorMessage, $minvalue = null, $maxvalue = null){
			parent::__construct($field, $errorMessage);
			$this->minvalue = $minvalue;
			$this->maxvalue = $maxvalue;
		}
		
		/**
		 * (non-PHPdoc)
		 * @see validation\rules.AbstractRule::execute()
		 */
		public function execute($obj){
			$value = $this->getFieldValue($obj);
			
			if(is_null($value) || $value === ''){
				return false;
			}
			
			if(!is_numeric($value)){
				return false;
			}
			
			if(!is_null($this->minvalue) && $value < $this->minvalue){
				return false;
			}
			
			if(!is_null($this->maxvalue) && $value > $this->maxvalue){
				return false;
			}
			
			return true;
		}
	}
}


/* End of file RequiredString.php */
/* Location: RequiredString.php */