<?php

namespace validation\rules {
	
	include_once __DIR__ . DIRECTORY_SEPARATOR . 'AbstractRule.php';
	
	use validation\Subject;

	/**
	 * Validates if the supplied string matches our needs
	 *
	 * @author Hugo Ferreira da Silva
	 *
	 */
	class RequiredString extends AbstractRule {
		/**
		 * minimum length
		 * @var int
		 */
		private $minlength;
		/**
		 * maximum length
		 * @var int
		 */
		private $maxlength;
		
		/**
		 * Constructor
		 * 
		 * @param string $field
		 * @param string $errorMessage
		 * @param int $minlength
		 * @param int $maxlength
		 * @author Hugo Ferreira da Silva
		 */
		public function __construct($field, $errorMessage, $minlength = null, $maxlength = null){
			parent::__construct($field, $errorMessage);
			$this->minlength = $minlength;
			$this->maxlength = $maxlength;
		}
		
		/**
		 * (non-PHPdoc)
		 * @see validation\rules.AbstractRule::execute()
		 */
		public function execute($obj){
			$value = $this->getFieldValue($obj);
			
			if(is_null($value) || $value === ''){
				return false;
			}
			
			if(!is_null($this->minlength) && strlen($value) < $this->minlength){
				return false;
			}
			
			if(!is_null($this->maxlength) && strlen($value) > $this->maxlength){
				return false;
			}
			
			return true;
		}
		
	}
	
}


/* End of file RequiredString.php */
/* Location: RequiredString.php */